﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja o zarobkach emeryta lub rencisty</title>
		<script runat="server">

    public class PrnParams: OkresContext {
    
        public PrnParams(Context context): base(context) {
            Date data = Aktualny;

            base.Okres = FromTo.Year(data.Year - 1);
        }
    
        [Browsable(false)]
        public override Date Aktualny {
            get { return base.Aktualny; }
            set { base.Aktualny = value; }
        }    
    
        [Priority(10)]
        public override FromTo Okres {
            get { return base.Okres; }
            set { base.Okres = value; }
        }

        bool raportSzczegółowy = false;
        [Priority(20)]
        public bool RaportSzczegółowy {
            get { return raportSzczegółowy; }
            set {
                raportSzczegółowy = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //Raport wykonywany wg miesiąca ZUS
        //static bool wgMiesiącaZUS = true;
        bool wgMiesiącaZUS = true;
        [Priority(1)]
        [Caption("Raport wg miesiąca ZUS")]
        public bool WgMiesiącaZUS {
            get { return wgMiesiącaZUS; }
            set {
                wgMiesiącaZUS = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        //Raport wykonywany wg daty wypłaty. Jeżeli wgMiesiącaZUS==true to pole jest ignorowane
        //static bool wgDatyWypłaty = false;
        bool wgDatyWypłaty = false;
        [Priority(2)]
        [Caption("Raport wg daty wypłaty")]
        public bool WgDatyWypłaty {
            get { return wgDatyWypłaty; }
            set {
                wgDatyWypłaty = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool pelneStanowisko = false;
        [Priority(3)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        bool okresyZatr = false;
        [Priority(4)]
        [Caption("Okresy zatrudnienia")]
        public bool OkresyZatr {
            get { return okresyZatr; }
            set {
                okresyZatr = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }		
		                
    PrnParams pars;
    [Context(Required=true)]
    public PrnParams Params {
        set { pars = value; }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set {
            srpars = value;
            pelneStanowisko = value.PelneStanowisko;
        }
    }

    bool pelneStanowisko = false;	    
            
    void OnContextLoad(Object sender, EventArgs args) {
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
        report = ReportHeader1;
        ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(ph);

        decimal brutto = 0;

        PlaceModule płace = PlaceModule.GetInstance(ph);

        System.Collections.Generic.Dictionary<YearMonth, decimal> dct = new System.Collections.Generic.Dictionary<YearMonth, decimal>();
        foreach (Pracownik pp in ph.Pracownik.PracownicyPowiązani) {
            SubTable elementy;
            if (srpars.WgMiesiącaZUS)
                elementy = płace.WypElementy.WgMiesiacZUS[pp];
            else if (srpars.WgDatyWypłaty)
                elementy = płace.WypElementy.WgDaty[pp];
            else
                elementy = płace.WypElementy.WgPracownik[pp];

            elementy = new SubTable(elementy, pars.Okres);

            foreach (WypElement e in elementy) {
                try {
                    if (e.PodstawaZUS || e.KodRSA!=null) {
                        brutto += e.Wartosc;
                        YearMonth ym;

                        if (srpars.WgMiesiącaZUS)
                            ym = e.MiesiacZUS;
                        else if (srpars.WgDatyWypłaty)
                            ym = new YearMonth(e.Data);
                        else
                            ym = new YearMonth(e.Okres.To);
                    
                    
                        decimal v;
                        if (!dct.TryGetValue(ym, out v))
                            dct.Add(ym, e.Wartosc);
                        else
                            dct[ym] = v + e.Wartosc;
                    }
                }
                catch { Msg(); }
            }
        }

        Periods bezpłatny = Periods.Empty;
        Periods chorobowy = Periods.Empty;
        Periods opieka = Periods.Empty;
        Periods macierzyński = Periods.Empty;
        Periods rehabilitacyjny = Periods.Empty;
        foreach (OkresNieobecności on in ph.Pracownik.Czasy.Nieobecnosci(pars.Okres, true))
            switch (on.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    bezpłatny += on.Okres; break;
                case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                    chorobowy += on.Okres; break;
                case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                    opieka += on.Okres; break;
                case PrzyczynaNieobecnosci.UrlopMacierzyński:
                    macierzyński += on.Okres; break;
                case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    rehabilitacyjny += on.Okres; break;
            }

        bezpłatny = bezpłatny.ToFlat();
        chorobowy = chorobowy.ToFlat();
        opieka = opieka.ToFlat();
        macierzyński = macierzyński.ToFlat();
        rehabilitacyjny = rehabilitacyjny.ToFlat();
        
        string niePrzebywał = ph.Plec == PłećOsoby.Mężczyzna ? "nie przebywał" : "nie przebywała";

        if (pars.RaportSzczegółowy) {
            Periods ps = Periods.New(pars.Okres).BreakByMonth();
            foreach (FromTo okres in ps) {
                YearMonth ym = new YearMonth(okres.To);
                decimal v;
                if (dct.TryGetValue(ym, out v)) {
                    labelMiesInfo.AddLine(ym);
                    labelMiesKwoty.AddLine(v);
                }
            }

            labelMiesInfo.AddLine("");
            labelMiesKwoty.AddLine("");
        }
        
        labelBrutto.EditValue = brutto;
        if (bezpłatny != Periods.Empty) {
            labelDniBezpłatnego.EditValue = bezpłatny.Days;
            labelOkresBezpłatnego.EditValue = FormatPeriods(bezpłatny);
        }
        else
            labelDniBezpłatnego.EditValue = niePrzebywał;

        if (chorobowy != Periods.Empty) {
            labelDniChorobowego.EditValue = chorobowy.Days;
            labelOkresChorobowego.EditValue = FormatPeriods(chorobowy);
        }
        else
            labelDniChorobowego.EditValue = niePrzebywał;

        if (opieka != Periods.Empty) {
            labelDniOpieki.EditValue = opieka.Days;
            labelOkresOpieki.EditValue = FormatPeriods(opieka);
        }
        else
            labelDniOpieki.EditValue = niePrzebywał;

        if (macierzyński != Periods.Empty) {
            labelDniMacierzynskiego.EditValue = macierzyński.Days;
            labelOkresMacierzynskiego.EditValue = FormatPeriods(macierzyński);
        }
        else
            labelDniMacierzynskiego.EditValue = niePrzebywał;

        if (rehabilitacyjny != Periods.Empty) {
            labelDniRehabilitacyjnego.EditValue = rehabilitacyjny.Days;
            labelOkresRehabilitacyjnego.EditValue = FormatPeriods(rehabilitacyjny);
        }
        else
            labelDniRehabilitacyjnego.EditValue = niePrzebywał;
                            
        labelOkresOd.EditValue = pars.Okres.From;
        labelOkresDo.EditValue = pars.Okres.To;

        if (srpars.OkresyZatr)
            ZatrudnienieOkresy(ph);
        else
            ZatrudnienieInfo(ph);

        if (ph.IdentyfikatorPodatkowy == IdentyfikatorPodatkowyPracownika.NIP) {
            miesiace9l.EditValue = "NIP:";
            miesiace10.Visible = false;
        }
        else {
            miesiace10l.EditValue = "PESEL:";
            miesiace9.Visible = false;
        }
    }

    void ZatrudnienieInfo(PracHistoria ph) {
        if (ph.Etat.Okres.Contains(pars.Aktualny))
            labelWymiarEtatu.EditValue = string.Format("Zatrudnienie trwa nadal w wymiarze: <strong>{0}</strong>.", ph.Etat.Zaszeregowanie.Wymiar);
        else if (UmowaZlecenie(ph.Pracownik))
            labelWymiarEtatu.EditValue = "Pracownik zatrudniony na umowę zlecenie.";
        else
            labelWymiarEtatu.EditValue = "Zatrudnienie trwa nadal w wymiarze: <strong>pracownik zwolniony</strong>.";
    }

    void ZatrudnienieOkresy(PracHistoria historia) {
        string s = "";
        string last = "";
        string firma = "";
        string nadal = "nadal";
        Date data = Date.Empty;
        Periods okresy = Periods.Empty;
        Pracownik pracownik = historia.Pracownik;
        FromTo okresZatrudnienia = historia.Etat.OkresZatrudnienia;
        
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            if (last != GetStanowisko(ph)) {
                last = GetStanowisko(ph);
                if (s == "")
                    s = "<strong><LI>" + last;
                else {
                    s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To == Date.MaxValue ? nadal : okresy.To.ToString()) + "</strong>,<LI><strong>" + last;
                    okresy = Periods.Empty;
                }
            }
            okresy += ph.Etat.EfektywnyOkres;
            if (data == Date.Empty)
                data = ph.Etat.Okres.From;
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty && ph.Etat.DataPrzejeciaPracownika != data) {
                if (firma != "")
                    firma += "<br/>";
                firma += string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong> (przejście w trybie art. 23' KP)",
                    ph.Etat.PoprzedniPracodawca,
                    data,
                    ph.Etat.DataPrzejeciaPracownika.AddDays(-1));
                data = ph.Etat.DataPrzejeciaPracownika;
            }
        }
        if (firma != "")
            firma += string.Format("<br/><strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                NazwaFirmy(historia),
                data,
                (okresZatrudnienia.To == Date.MaxValue ? nadal : okresZatrudnienia.To.ToString()));
        else
            firma = string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                NazwaFirmy(historia),
                okresZatrudnienia.From,
                (okresZatrudnienia.To == Date.MaxValue ? nadal : okresZatrudnienia.To.ToString()));

        if (okresy != Periods.Empty)
            s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To == Date.MaxValue ? nadal : okresy.To.ToString()) + "</strong>";

        ArrayList wymiary = new ArrayList();
        Fraction lastw = Fraction.Zero;
        okresy = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            if (lastw != ph.Etat.Wymiar) {
                if (okresy != Periods.Empty)
                    wymiary.Add(new DictionaryEntry(lastw, okresy));
                lastw = ph.Etat.Wymiar;
                okresy = Periods.Empty;
            }
            okresy += ph.Etat.EfektywnyOkres;
        }

        if (okresy != Periods.Empty)
            wymiary.Add(new DictionaryEntry(lastw, okresy));

        string wymiar = "";
        if (wymiary.Count < 2)
            wymiar = "<strong>" + historia.Etat.Wymiar + "</strong>.<br/>";
        else {
            string ss = "";
            foreach (DictionaryEntry de in wymiary) {
                Periods pe = (Periods)de.Value;
                ss += "<li><strong>" + (Fraction)de.Key + "</strong> od <strong>" + pe.From + "</strong> do <strong>" + (pe.To == Date.MaxValue ? nadal : pe.To.ToString()) + "</strong></li>";
            }
            wymiar = ss;
        }

        labelWymiarEtatu.EditValue = string.Format("Zatrudnienie:<br/>{0}<br/>w wymiarze: <strong>{1}</strong>", firma, wymiar);
    }
    
    bool UmowaZlecenie(Pracownik p) {
        Date d = pars.Aktualny;
        foreach (Umowa u in p.Umowy)
            if (u.Okres.Contains(d))
                return true;
        return false;
    }        

    static string FormatPeriods(Periods ps) {
        string s = ps.ToString();
        s = s.Replace(")(", "</strong>,<br/><strong>");
        s = s.Replace("(", "");
        s = s.Replace(")", "");
        return s;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (pelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }
    
    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
		        
    string NazwaFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nazwa = core.Config.Firma.Pieczątka.Nazwa;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
        }
        return nazwa;
    }

    public static void Msg(object obj) {
    }

    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZaświadczenieOZarobkach" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" 
                TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" 
                oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="Informacja o wysokości przychodów&lt;br/&gt;emeryta lub rencisty do ZUS&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Oddział ZUS:&lt;strong&gt; {1}&lt;BR&gt;&lt;/strong&gt;Numer emerytury/renty:&lt;strong&gt; {2}&lt;p align=right&gt;&lt;/strong&gt;%MIEJSCOWOSC%, {0}&lt;strong&gt;&lt;/p&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;" 
                runat="server" DataMember0="Context.ActualDate.Actual"
                DataMember1="InneDane.OddzialZUS" DataMember2="PrawoEmRent.Numer"></cc1:reportheader>
			
			<p>
			<table cellpadding="0" cellspacing="0" width="100%" 
                    style="font-family: Verdana; font-size: 10pt">
                <tr>
                    <td width="25%">
				Nazwisko:</td>
                    <td width="25%">
				<ea:datalabel id="miesiace3" runat="server" DataMember="Nazwisko"></ea:datalabel>
			
			        </td>
                    <td width="25%">
                Imiona:</td>
                    <td>
                        <ea:datalabel id="miesiace4" runat="server" 
                    DataMember="Imie"></ea:datalabel>
				&nbsp;<ea:datalabel id="miesiace11" runat="server" DataMember="ImieDrugie"></ea:datalabel>
			
			        </td>
                </tr>
                <tr>
                    <td>
                Imię ojca:</td>
                    <td>
                        <ea:datalabel id="miesiace5" 
                    runat="server" DataMember="ImieOjca"></ea:datalabel>
			
                    </td>
                    <td>
                                Imię matki:</td>
                    <td>
                        <ea:datalabel id="miesiace6" 
                    runat="server" DataMember="ImieMatki"></ea:datalabel>
			
			        </td>
                </tr>
                <tr>
                    <td>
                Data urodzenia:</td>
                    <td>
                        <ea:datalabel id="miesiace7" 
                    runat="server" DataMember="Urodzony.Data"></ea:datalabel>
			
			        </td>
                    <td>
                        Miejsce urodzenia:</td>
                    <td>
                        <ea:datalabel id="miesiace8" 
                    runat="server" DataMember="Urodzony.Miejsce"></ea:datalabel>
			
			        </td>
                </tr>
                <tr>
                    <td>
                        <ea:datalabel id="miesiace10l" runat="server" Bold="false"></ea:datalabel>
                    </td>
                    <td>
                        <ea:datalabel id="miesiace10" runat="server" DataMember="PESEL"></ea:datalabel>
			        </td>
                    <td>
                        <ea:datalabel id="miesiace9l" runat="server" Bold="false"></ea:datalabel>
                    </td>
                    <td>
                        <ea:datalabel id="miesiace9" runat="server" DataMember="NIP"></ea:datalabel>
			        </td>
                </tr>
            </table>
            </p>
            <p>
				<table width="100%" style="font-family: Verdana; font-size: 10pt">
                    <tr>
                        <td colspan="4">
                                                        Zamieszkały:
                        </td>
                    </tr>
                    <tr>
                        <td width="25%">
                Gmina/Dzielnica:</td>
                        <td width="25%">
                            <ea:datalabel 
                    id="miesiace12" runat="server" DataMember="Adres.Gmina"></ea:datalabel>
			
			            </td>
                        <td width="25%">
                Kod pocztowy:</td>
                        <td>
                            <ea:datalabel id="miesiace13" 
                    runat="server" DataMember="Adres.KodPocztowyS"></ea:datalabel>
			
			            </td>
                    </tr>
                    <tr>
                        <td>
                Miejscowość:</td>
                        <td>
                            <ea:datalabel id="miesiace14" 
                    runat="server" DataMember="Adres.Miejscowosc"></ea:datalabel>
			
			            </td>
                        <td>
                Ulica:</td>
                        <td>
                            <ea:datalabel id="miesiace15" runat="server" 
                    DataMember="Adres.Ulica"></ea:datalabel>
			
			    </td>
                    <tr>
                        <td>
                Nr domu:</td>
                        <td>
                            <ea:datalabel id="Datalabel1" 
                    runat="server" DataMember="Adres.NrDomu"></ea:datalabel>
			
			            </td>
                        <td>
                Nr lokalu:</td>
                        <td>
                            <ea:datalabel id="Datalabel2" runat="server" 
                    DataMember="Adres.NrLokalu"></ea:datalabel>
			
			    </td>
                    </tr>
                </table>
			</p>
			<p align="center">
				<table>
                    <tr>
                        <td style="font-family: Verdana; font-size: 10pt; ">
                            Informacja o wynagrodzeniu uzyskanym w okresie od 
                <ea:datalabel id="labelOkresOd" runat="server"></ea:datalabel>
			&nbsp;do <ea:datalabel id="labelOkresDo" runat="server"></ea:datalabel>
			    .</td>
                    </tr>
                </table>
            </p>
			    <p>
            <table cellpadding="0" cellspacing="0" width="100%" 
                        style="font-family: Verdana; font-size: 10pt">
                <tr>
                    <td width="50%">
                        <ea:datalabel id="labelMiesInfo" 
                    runat="server" Bold="False"></ea:datalabel>
			
				Brutto:</td>
                    <td>
                        <ea:datalabel id="labelMiesKwoty" 
                    runat="server" Format="{0:n}"></ea:datalabel>
			
                        <ea:datalabel id="labelBrutto" 
                    runat="server" Format="{0:n}"></ea:datalabel>
			
                    </td>
                </tr>

                <tr>
                    <td>Liczba dni:</td>
                </tr>
                <tr>
                    <td>&nbsp;- Wynagrodzenia i zasiłku chorobowego:</td>
                    <td>
                        <ea:datalabel id="labelDniChorobowego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td valign="top">&nbsp;&nbsp;&nbsp;W okresie:</td>
                    <td>
                        <ea:datalabel id="labelOkresChorobowego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td>&nbsp;- Zasiłku opiekuńczego</td>
                    <td>
                        <ea:datalabel id="labelDniOpieki" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td valign="top">&nbsp;&nbsp;&nbsp;W okresie:</td>
                    <td>
                        <ea:datalabel id="labelOkresOpieki" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td>&nbsp;- Zasiłku macierzyńskiego</td>
                    <td>
                        <ea:datalabel id="labelDniMacierzynskiego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td valign="top">&nbsp;&nbsp;&nbsp;W okresie:</td>
                    <td>
                        <ea:datalabel id="labelOkresMacierzynskiego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td>&nbsp;- Świadczenia rehabilitacyjnego</td>
                    <td>
                        <ea:datalabel id="labelDniRehabilitacyjnego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td valign="top">&nbsp;&nbsp;&nbsp;W okresie:</td>
                    <td>
                        <ea:datalabel id="labelOkresRehabilitacyjnego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td>&nbsp;- Urlopu bezpłatnego:</td>
                    <td>
                        <ea:datalabel id="labelDniBezpłatnego" runat="server"></ea:datalabel>
			        </td>
                </tr>
                <tr>
                    <td valign="top">&nbsp;&nbsp;&nbsp;W okresie:</td>
                    <td>
                        <ea:datalabel id="labelOkresBezpłatnego" runat="server"></ea:datalabel>
			        </td>
                </tr>
            </table>
            </p>
            <p>
				<table cellpadding="0" cellspacing="0" 
                    style="font-family: Verdana; font-size: 10pt" width="100%">
                    <tr>
                        <td>
				Od w/w płac zakład odprowadził składkę ZUS.</td>
                    </tr>
                    <tr>
                        <td>
                                <ea:datalabel id="labelWymiarEtatu" runat="server" Bold="False"></ea:datalabel>
			            </td>
                    </tr>
                </table>
                                </p>
			
			<cc1:ReportFooter id="ReportFooter1" runat="server" Height="77px" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Width="50" SubtitleType="Empty"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle
						Width="50" 
                        Caption="Podpis i pieczęć imienna kierownika zakładu lub osoby przez niego upoważnionej"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>
